/*****************************************************************************
*  Time.c   Timer 0 init, isr, and functions               
*                                  
*
*   IEC Medical Alert Tone Generator Application                                                                        
*   
*   Copyright(C) 2007, NXP Semiconductor
*   All rights reserved.                  
*                                                                            
******************************************************************************/

#include "LPC17xx.h"                           // LPC21XX Peripheral Registers
#include "multi_tone_gen.h"
#include "command.h"
#include "seqencer.h"

 #define LED_A       0x04		  //   For MCB1700 Test 
 #define LED_B       0x08		  //   For MCB1700 Test
 #define LED_C       0x10		  //   For MCB1700 Test
 #define LED_D       0x20		  //   For MCB1700 Test

long timeval;
long sequence;
unsigned char alarm;
unsigned char note_on;		// flag to turn on tone
unsigned char note_level;
unsigned short mscount;
enum {GENERAL,OXYGEN,VENTILATION,CARDIOVASCULAR,TEMPERATURE,DRUG_DELIVERY,
		PERRFUSION,POWER_FAIL,LOW_ALARM};
		     
void TIMER0_IRQHandler(void);
void EnvelopeControl(void);

void init_timer (void)
{
  TIM0->MR0 = 959;         // 40 uSec = 960-1 counts (25ksps @ 24 mhz) 
  TIM0->MCR = 3;           // Interrupt and Reset on MR0
  TIM0->TCR = 1;           // Timer0 Enable
  timeval=0;			   // variable initializations
  mscount=0;
  sequence = 0;		
}

void TIMER0_IRQHandler (void)
{	
	if (envelope_on )
	{
		GPIO2->FIOSET = LED_A;		// used to test time to generate tones
		OutputTones(active_note,note_level); // parameters are set in sequencer
		GPIO2->FIOCLR = LED_A;	   // used to test time to generate tones
	}			
	TIM0->IR = 1;               // Clear interrupt flag
	timeval++;
	if (timeval == 25)			// millisecond interval (@ 25 khz sample rate)
	{
	    if (sequence)
		{
			switch (priority)
	   		{
		 		case 1:
		 			HighPriSequence(alarm);
					break;
		 		case 2:
		 			MedPriSequence(alarm);
					break;
		 		case 3:
		 			LowPriSequence(alarm);
					break;
				case 4:
		 			TestSequence(alarm);
					break;
	   		}
		}
		mscount++;				// increment ms counter
		timeval = 0;			// clear interval counter
		EnvelopeControl();		
	}

}

